program imgtest;

uses crt, xvga256, xkeybrd;

var
   img          : TImage;
   pal          : VGAPalette;
   buffer_ptr   : pointer;

begin
  clrscr;
  xSetVGAMode;
  xKeyboardInit;
  xCreateBuffer(buffer_ptr);

  xLoadPaletteBMP('valley.bmp');
  xLoadBitmap(img, 'valley.bmp');
  xClearScreen(buffer_ptr, 4);

  xGetPaletteVGA(pal);           { Get current VGA palette }
  xFadeOut(1);                   { Fade out the screen }

  xDrawBitmap(buffer_ptr, 0, 0, img, FALSE);
  xWaitForVertRetrace;
  xCopyBuffer(buffer_ptr, ptr(VGA_SEGMENT, 0));

  xFadeIn(pal, 15);              { Fade in the screen }

  { Main program loop }
  while not key[KEY_ESC] do
  begin
    xClearScreen(buffer_ptr, 4);  { Clear the buffer }
    xDrawBitmap(buffer_ptr, 0, 0, img, FALSE);
    xWaitForVertRetrace;
    xCopyBuffer(buffer_ptr, ptr(VGA_SEGMENT, 0));
  end;

  xFadeOut(20);
  {xMeltScreen(buffer_ptr, 0);}
  xDisableKeyboard;
  xFreeImage(img);
  xFreeBuffer(buffer_ptr);       { Free the buffer }
  xSetTxtMode;
end.